%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
% mfile to solve of "Integrated design with UIO"
% Jianglin Lan, 2015-0903, function file
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function sys_state = FTC_sys_performance(t,xx,A,B,Fa,D,C,Delta_A,Kx,M,G,L,H)
hat_eta = xx(1);
xi1 = xx(2);
xi2 = xx(3);
xi3 = xx(4);
x1 = xx(5);
x2 = xx(6);

global Int_ffa Int_yy1 Int_yy2 Int_ts Int_count Int_tmp Int_hatfa Int_u Int_u0

E = pinv(B)*Fa;

Y = 0.05*ones(1,2);
omega =  0.5213;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
N = pinv(C*B) - Y * (eye(2) - C*B*pinv(C*B));
psi = 0.001;  
phi = omega*psi + 0.01;
varep1 = 0.001; varep2 = 1.0e-3; sigma = 1;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% disturbance and fault
d = 0.01 * sin(t);
fm = -Theta(t)*Int_u0;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
x = [x1;x2];
y = C*x;
xi = [xi1;xi2;xi3];
hat_x = xi + H*y;

% sliding surface
yc = y;
s_t = N*yc;

% controller
u_l = - [Kx E]*hat_x;
rho2 = hat_eta + varep1 + phi;

u_n = -rho2 * (s_t / (norm(s_t,2) + varep2));

u = u_l + u_n;
Int_u0 = u;

dot_hat_eta = sigma * norm(s_t,2);

%observer
dot_xi = M* xi + G*u + L*y;

% sys dynamic
dot_x = (A + Delta_A)*x + B*(1 - Theta(t))*u + D*d;

if mod(Int_tmp,18)==0
    Int_count = Int_count + 1;
Int_ts(Int_count) = t;
Int_ffa(Int_count) = fm;
Int_yy1(Int_count) = yc(1);
Int_yy2(Int_count) = yc(2);
Int_hatfa(Int_count) = fm - hat_x(3);
Int_u(Int_count) = u;
end
Int_tmp = Int_tmp + 1;

sys_state = [dot_hat_eta;dot_xi;dot_x];